/**********************************************************************************************
* Device      : AD18F08
* Author      :
* Version     : V0.0.1
* Date        : 2023.5.6
* Description : 1、ADC间隔1ms采集一次，并产生ADC的比较中断；1ms由TIMER1定时
*               2、ADCMPMODE=0时采集值大于ADCMP1H产生中断ADCMP1IF(低优先级中断，PB2翻转)或者小于ADCMP0H产生中断ADCMP0IF（高优先级中断，PB5翻转）
*
*
***********************************************************************************************/
#include "AD18F08.h"
#include <stdio.h>
#include "periph.h"
#include "usart.h"

/*********************************************************************************************
*
* _FINTOSC_DIV1   :  内部RC振荡器频率选择
* _DBG_OFF        :  DEBUG模式使能位
* _LVREN_OFF       :  禁止LVR
* _LVR24V         :  LVR的电压选择为2.4V
* _FLASH_CP1_OFF  :  1K~2K*16 FLASH CP保护
* _FLASH_CP0_OFF  :  0~1K*16 FLASH CP保护
* _IDIS_OFF		    :  模拟IO打开，数据读取控制位
* _CKSUM_OFF      :  校验使能位
* _CBP_OFF		    :  代码保护选择位
* _RESETE_OFF     :  外部复位使能
* _RSEL			      :  端口上下拉电阻选择
* _STV_ON		      :  堆栈溢出复位
* _PSUT_2		      :  上电复位时间选择
* _FCPU_4T        :  指令周期选择4T
* _WDTE_OFF       :  看门狗使能
* _TWDT_000       :  看门狗溢出时间选择
* _OSCM_HIRC_16M  :  系统时钟选择高速时钟
* _MTPDIS_OFF     :  SWD模式下读FALSH控制
* _ADCSP_ON		    :	 ADC采集速度选择
*

************************************************************************************************/

__CONFIG(1,_FINTOSC_DIV1_1L     & _DBG_OFF_1L       & _LVREN_OFF_1L     & _LVR24V_1L                                                                   );
__CONFIG(2,_FLASH_CP1_OFF_2L    & _FLASH_CP0_OFF_2L & _IDIS_OFF_2L     & _CKSUM_OFF_2L  & _CBP_OFF_2L   & _RESETE_OFF_2L & _RSEL_LOW_2L & _STV_ON_2L  );
__CONFIG(3,_PSUT_2_3L           & _FCPU_4T_3L       & _WDTE_OFF_3L    & _TWDT_100_3L                                                                 );
__CONFIG(4,_OSCM_HIRC_16M_4L    & _MTPDIS_OFF_4L    & _ADCSP_ON_4L                                                                                    );

unsigned short VOLT ;


void main(void)
{
    GPIO_Init();
    //usart_init();
    ADC_Config(); //选择PA5口输入电压进行采集，采集值和比较值进行比较产生ADCMP0和ADCMP1中断;
    timer1_int(); //定时1ms,启动ADC

    //printf("AD18F08_test\r\n");

    while(1)
    {
      VOLT =ADC_SampleFilter();
     // printf("AD C_Vol =  %d \r\n",VOLT);
    }
}
// 中断服务函数
// 高优先级中断函数

void interrupt ISR_h(void)
{
     if(ADCMP0IE&&ADCMP0IF)
     {
       ADCMP0IF = 0;
       TRISB5   = 0; //设置PB5为输出模式
       PB5      = ~PB5; //PB5的翻转用于检测ADCMP0IF的中断是否产生
     }
}

//低优先级中断函数
void interrupt low_priority ISR_l (void)
{
    if(ADCMP1IE&&ADCMP1IF)
     {
       ADCMP1IF = 0;
       TRISB2   = 0;    //设置PB2为输出模式
       PB2      = ~PB2; //PB2的翻转用于检测ADCMP1IF的中断是否产生
     }
}

